<!DOCTYPE html>
<?php 
$custom_link_login = get_theme_mod( 'custom_link_login_setting' );
$custom_link_daftar = get_theme_mod( 'custom_link_daftar_setting');

$custom_color_header = get_theme_mod( 'custom_color_header', '#1e0000' );
$custom_color_background = get_theme_mod( 'custom_color_background', '#000000' );
$custom_menu_game = get_theme_mod( 'custom_menu_game', '#d51307' );
$custom_color_login = get_theme_mod( 'custom_color_login', '#d51307' );
$custom_color_daftar = get_theme_mod( 'custom_color_daftar', '#f6bb23' );
$custom_color_footer = get_theme_mod( 'custom_color_footer', '#4b120f' );
$custom_color_border = get_theme_mod( 'custom_color_border', '#d51307' );
$custom_color_link = get_theme_mod( 'custom_color_link', '#d51307' );
?>
<html amp <?php language_attributes(); ?>>
 <head>
   <title><?php bloginfo('name'); ?> - <?php is_front_page() ? bloginfo('description') : wp_title(''); ?></title>
   <meta charset="<?php bloginfo( 'charset' ); ?>">
   <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
   <?php wp_head(); ?>
   <script async src="https://cdn.ampproject.org/v0.js"></script>
   <style amp-boilerplate>body{-webkit-animation:-amp-start 8s steps(1,end) 0s 1 normal both;-moz-animation:-amp-start 8s steps(1,end) 0s 1 normal both;-ms-animation:-amp-start 8s steps(1,end) 0s 1 normal both;animation:-amp-start 8s steps(1,end) 0s 1 normal both}@-webkit-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-moz-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-ms-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-o-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@keyframes  -amp-start{from{visibility:hidden}to{visibility:visible}}</style><noscript><style amp-boilerplate>body{-webkit-animation:none;-moz-animation:none;-ms-animation:none;animation:none}</style></noscript>
    <style amp-custom>
		#menu-login{
			margin-left: auto;
			display: flex;
			align-items: center;
			list-style: none;
		}
		.menu {
			margin-left: auto;
			display: flex;
			align-items: center;
		}
		.sign-in a{
			color: #000000;
    		text-decoration: none;
		}
		.sign-up a{
			color: #ffffff;
    		text-decoration: none;
		}
		.sign-in{
			color: #000000;
			background: <?php echo $custom_color_login ?>;
			border: 1px solid #d51307;
			outline: none;
			border-radius: 5px;
			padding: 7px 13px;
			border: none;
			font-size: 14px;
			font-weight: 600;
			margin-left: 5px;
			box-shadow: 0px 1px 1px rgba(0, 0, 0, 0.25);
			text-decoration: none;
		}
		.sign-up{
			background: <?php echo $custom_color_daftar ?>;
			color: #ffffff;
			border: 1px solid #f6bb23;
			text-decoration: none;
			outline: none;
			border-radius: 5px;
			padding: 7px 13px;
			border: none;
			font-size: 14px;
			font-weight: 600;
			margin-left: 5px;
			/* padding: 5px 0px; */
			box-shadow: 0px 1px 1px rgba(0, 0, 0, 0.25);
			text-align: center;
		}
		
        body {
			font-family: 'Open Sans', sans-serif;
			background: <?php echo $custom_color_background?>;
			background-size: cover;
			background-position: center;
			background-repeat: no-repeat;
			background-attachment: fixed;
			padding-bottom: 80px;
        }

        .header-mobile {
        position: sticky;
        top: 0;
        z-index: 1;
        padding: 8px 10px;
        display: flex;
        align-items: center;
        background: <?php echo $custom_color_header?>;
        border-bottom: 1px solid <?php echo $custom_color_border?>;
        }

        .header-mobile .mobile-logo {
        min-height: 30px;
        }

        .header-mobile .mobile-logo amp-img img {
        height: 35px;
        object-fit: contain;
        object-position: left;
        }

        .mobile-button {
        margin-left: auto;
        display: flex;
        align-items: center;
        }

        .mobile-button button {
        outline: none;
        border-radius: 5px;
        min-width: 65px;
        min-height: 33px;
        border: none;
        font-size: 14px;
        font-weight: 600;
        margin-left: 5px;
        padding: 5px 0px;
        box-shadow: 0px 1px 1px rgba(0, 0, 0, 0.25);
        }

        .mobile-button .login {
        color: #000000;
        background: <?php echo $custom_color_login ?>;
        border: 1px solid #d51307;
        }

        .mobile-button .login a {
        text-decoration: none;
        color: #000000;
        }

        .mobile-button .register {
        background: <?php echo $custom_color_daftar ?>;
        border: 1px solid #f6bb23;
        text-decoration: none;
        }

        .mobile-button .register a {
        color: #ffffff;
        text-decoration: none;
        }

        .mobile-button .menu {
		display: block;
        margin-left: 5px;
        color: #000000;
        background: <?php echo $custom_color_login ?>;
        border: 1px solid #d51307;
        border-radius: 5px;
        padding: 5px 5px;
        min-width: 35px;
        text-align: center;
        }

        amp-sidebar {
          background: #3e0000;
          border: 1px solid <?php echo $custom_color_border?>;
          width: 250px;
          color: #fff;
        }

        .sidenav__header {
        background: #000000;
        padding: 20px;
        border-bottom: 2px solid rgba(255, 255, 255, 0.1);
        }

        .sidenav__header-user {
        color: #fff;
        font-size: 12px;
        font-weight: 500;
        font-weight: 600;
        }

        .sidenav__header-logo {
        margin: 10px 0px 15px;
        text-align: center;
        }

        .sidenav__header-logo amp-img img {
        height: 60px;
        object-fit: contain;
        }

        .sidenav-button-title {
        text-align: center;
        color: #fff;
        font-size: 13px;
        font-weight: 600;
        }

        .sidenav-button {
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 8px 0px;
		list-style: none;
        }
		
		.sidenav-button .sign-in{
       		padding: 7px 25px;
        }

		.sidenav-button .sign-up{
       		padding: 7px 25px;
        }

        .sidenav-button button {
        outline: none;
        border-radius: 5px;
        min-width: 100px;
        border: none;
        font-size: 12px;
        font-weight: 500;
        padding: 10px 0px;
        box-shadow: 0px 1px 1px rgb(0 0 0 / 25%);
        }

        .sidenav-button .btn-login {
        color: #000000;
        background: #d51307;
        border: 1px solid #d51307;
        margin-right: 5px;
        font-weight: 600;
        }

        .sidenav-button .btn-login a {
        text-decoration: none;
        color: #000000;
        font-weight: 600;
        }

        .sidenav-button .btn-register {
        background: #FF0404;
        border: 1px solid #FF0404;
        text-decoration: none;
        }

        .sidenav-button .btn-register a {
        text-decoration: none;
        color: #ffffff;
        font-weight: 600;
        }

        .sidenav-password {
        text-align: right;
        font-size: 13px;
        }

        .sidenav-password a {
        text-align: right;
        font-size: 13px;
        color: #fff;
        text-decoration: none;
        }

        .sidenav-list {
        padding: 0px 15px;
		list-style: none;
        }
		.sidenav-list .menu-item{
			list-style: none;
			font-size: 12px;
			border-bottom: 1px solid rgba(255, 255, 255, .2);
			display: flex;
			align-items: center;
			padding: 10px;
			color: #fff;
		}
		.sidenav-list .menu-item a{
			color: #fff;
			text-decoration: none;
			font-weight: 500;
		}
		.sidenav-list .menu-item a i{
			width: 14px;
    		margin-right: 10px;
		}
        .sidenav-list ul {
        padding-left: 0px;
        margin-bottom: 0px;
        margin-top: 0px;
        }

        .sidenav-list ul li {
        list-style: none;
        font-size: 12px;
        border-bottom: 1px solid rgba(255, 255, 255, 0.2);
        display: flex;
        align-items: center;
        padding: 10px;
        color: #fff;
        }

        .sidenav-list ul li a {
        color: #fff;
        text-decoration: none;
        font-weight: 500;
        }

        .sidenav-list ul li i {
        width: 14px;
        margin-right: 10px;
        }

        .home__menu {
        padding-right: 15px;
        padding-left: 15px;
        margin-right: auto;
        margin-left: auto;
        }

        .menu-games {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        grid-gap: 15px;
        margin: 20px 0;
        }

        .menu-games a {
        text-decoration: none;
        }

        .games-item {
        background: transparent;
        text-align: center;
        }

        .games-item amp-img {
        animation: bounce 2s infinite alternate;
        }

        .games-item amp-img img {
        object-fit: contain;
        }

        .game-border {
        border-radius: 20px;
        margin-top: 10px;
        max-width: 200px;
        margin-left: auto;
        margin-right: auto;
        }

        .games-name {
        background: <?php echo $custom_menu_game?>;
        font-size: 13px;
        padding: 10px 5px;
        font-weight: 700;
        color: #000000;
        border-radius: 20px;
        }

        @keyframes bounce {
        0% {
            transform: translateY(-3px)
        }

        50% {
            transform: translateY(3px)
        }

        100% {
            transform: translateY(0)
        }
        }

        .home__seo {
        padding: 0 15px;
        margin-top: 25px;

        }
		.home__seo header {
			background: #f6bb23;
			font-size: 13px;
			padding: 20px;
			font-weight: 700;
			color: #000000;
			border-radius: 10px;
			margin-bottom: 14px;
		}
		
        .home__seo .game__seo {
        background: #000000;
        color: #fff;
        border-radius: 10px;
        padding: 15px 0;
		border: 2px solid <?php echo $custom_color_border?>;
        }

        .home__seo .game__seo .seo-content {
        padding: 0 15px 10px;
        font-size: 16px;
        text-align: justify;
        }

        .home__seo .seo-mobile .seo-mob-title {
        background: transparent;
        text-align: center;
        padding: 10px 15px;
        border: 0;
        border-radius: 10px;
        font-size: 16px;
        font-weight: 600;
        margin: 0;
        }

        .home__seo .seo-mobile .seo-mob-content {
        padding: 0 15px 10px;
        font-size: 16px;
        text-align: justify;
        }

        .home__seo .seo-mobile .seo-mob-content h1 {
        font-size: 1.25rem;
        }

        .home__seo .seo-mobile .seo-mob-content h2 {
        font-size: 1.2rem;
        }

        .home__seo .seo-mobile .seo-mob-content h3 {
        font-size: 1.15rem;
        }

        .home__seo .seo-mobile .seo-mob-content h4 {
        font-size: 1.1rem;
        }

        .home__seo .seo-mobile .seo-mob-content h5 {
        font-size: 1.05rem;
        }

        .home__seo .seo-mobile .seo-mob-content h6 {
        font-size: 1rem;
        }

        .home__seo .seo-mobile .seo-mob-content p {
        font-size: 14px;
        }

        .footer-mobile {
        background: <?php echo $custom_color_footer ?>;
        position: fixed;
        bottom: 0;
        right: 0;
        left: 0;
        z-index: 997;
        display: grid;
        grid-template-columns: repeat(4, 1fr);
		list-style:none;
        }

        .footer-mobile .footer-item {
        text-align: center;
        padding: 12px 5px 10px;
        border-right: 2px solid <?php echo $custom_color_border?>;
        border-top: 2px solid <?php echo $custom_color_border?>;
        color: #fff;
        text-decoration: none;
        }

        .footer-mobile .footer-item .footer-icon i {
        font-size: 20px;
        }

        .footer-mobile .footer-item .footer-title {
        font-size: 13px;
        font-weight: 600;
        }

        .home__seo .seo-mobile .seo-mob-content img {
            width: 100%;
        }
		
		a {
			color: <?php echo $custom_color_link?>;
		}
    </style>

    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,500;0,600;0,700;1,400&display=swap">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.8.1/css/all.css" type="text/css"/>
    <script async custom-element="amp-sidebar" src="https://cdn.ampproject.org/v0/amp-sidebar-0.1.js"></script>
    <script async custom-element="amp-accordion" src="https://cdn.ampproject.org/v0/amp-accordion-0.1.js"></script>
    <script async custom-element="amp-carousel" src="https://cdn.ampproject.org/v0/amp-carousel-0.2.js"></script>
    <script async custom-element="amp-lightbox" src="https://cdn.ampproject.org/v0/amp-lightbox-0.1.js"></script>
    <script async custom-element="amp-form" src="https://cdn.ampproject.org/v0/amp-form-0.1.js"></script>
    <script async custom-element="amp-analytics" src="https://cdn.ampproject.org/v0/amp-analytics-0.1.js"></script>
 </head>
 <body <?php body_class(); ?>>
 <div class="header-mobile">
        <div class="mobile-logo">
        <a href="<?php echo esc_url(home_url('/')); ?>">
            <?php
            if ( has_custom_logo() ) {
                $custom_logo_id = get_theme_mod( 'custom_logo' );
                $logo_url = wp_get_attachment_image_url( $custom_logo_id, 'full' ); // 'full' indicates the image size
                echo '<amp-img src="' . esc_url( $logo_url ) . '" alt="WebsiteLogo" width="140" height="30" layout="intrinsic"></amp-img>';
            } else {
                echo '<amp-img src="" alt="WebsiteLogo" width="140" height="30" layout="intrinsic"></amp-img>';
            }
            ?>
        </a>
        </div>
        <div class="mobile-button">
            <?php
					// Mendapatkan ID menu berdasarkan lokasi menu
					$locations = get_nav_menu_locations();
					$header_menu_id = $locations['header-menu'];

					// Mendapatkan daftar item menu dari database
					$menu_items = wp_get_nav_menu_items($header_menu_id);

					// Periksa apakah ada item menu
					if ($menu_items) {
						// Loop melalui setiap item menu
						foreach ($menu_items as $menu_item) {
							// Dapatkan kelas menu yang telah ditetapkan
							$classes = $menu_item->classes;
							$class_string = implode(' ', $classes); // Ubah array kelas menjadi string

							// Tampilkan setiap item menu sebagai link dengan kelas kustom
							echo '<a class="' . $class_string . '" href="' . $menu_item->url . '">' . $menu_item->title . '</a>';
						}
					}
					?>
            <button class="menu" on="tap:sidenav">
                <i class="fas fa-bars"></i>
            </button>
        </div>
    </div>