<?php
// This function enqueues the Normalize.css for use. The first parameter is a name for the stylesheet, the second is the URL. Here we
// use an online version of the css file.

// Register a new sidebar simply named 'sidebar'
function add_widget_support() {
    register_sidebar( array(
                    'name'          => 'Sidebar',
                    'id'            => 'sidebar',
                    'before_widget' => '<div>',
                    'after_widget'  => '</div>',
                    'before_title'  => '<h2>',
                    'after_title'   => '</h2>',
    ) );
}
// Hook the widget initiation and run our function
add_action( 'widgets_init', 'add_widget_support' );

 // Register a new navigation menu
 function add_Main_Nav() {
    register_nav_menu('header-menu',__( 'Header Menu' ));
  }
  // Hook to the init action hook, run our navigation menu function
  add_action( 'init', 'add_Main_Nav' );

// Register a new navigation menu
 function add_Main_Footer_Nav() {
    register_nav_menu('footer-menu',__( 'Footer Menu' ));
  }
  // Hook to the init action hook, run our navigation menu function
  add_action( 'init', 'add_Main_Footer_Nav' );

// Register a new navigation menu
 function add_Main_Sidenav_Nav() {
    register_nav_menu('sidenav-menu',__( 'Sidenav Menu' ));
  }
  // Hook to the init action hook, run our navigation menu function
  add_action( 'init', 'add_Main_Sidenav_Nav' );

  function phishingpolice_setup() {
   // Support for Custom Logo
   add_theme_support('custom-logo', array(
       'height'      => 30,
       'width'       => 140,
       'flex-width'  => true,
       'flex-height' => true,
   ));
}

add_action('after_setup_theme', 'phishingpolice_setup');

function remove_all_styles_from_head() {
    global $wp_styles;
    // Looping untuk menonaktifkan semua style
    foreach( $wp_styles->queue as $style ) {
        wp_dequeue_style( $style );
        wp_deregister_style( $style );
    }
}
add_action('wp_enqueue_scripts', 'remove_all_styles_from_head', 100);

function custom_theme_customize_panel( $wp_customize ) {
    // Buat sebuah panel kustom
    $wp_customize->add_panel( 'custom_panel', array(
        'title' => __( 'Phishingpolice Settings', 'phishingpolice' ),
        'priority' => 10,
    ));

	// Buat sebuah section untuk link settings di dalam panel "Phishingpolice Settings"
    $wp_customize->add_section( 'links_section', array(
        'title' => __( 'Sidebar Link Settings', 'phishingpolice' ),
        'panel' => 'custom_panel',
        'priority' => 9,
    ));

   // Buat sebuah section untuk slider
    $wp_customize->add_section( 'slider_section', array(
        'title' => __( 'Slider', 'phishingpolice' ),
        'panel' => 'custom_panel',
        'priority' => 10,
    ));

    // Tambahkan pengaturan kustom untuk upload gambar slider
    $wp_customize->add_setting( 'slider_image_1', array(
        'default' => '',
        'transport' => 'refresh', // Metode penyimpanan data
    ));

    // Tambahkan kontrol untuk upload gambar slider
    $wp_customize->add_control( new WP_Customize_Upload_Control( $wp_customize, 'slider_image_1_control', array(
        'label' => __( 'Unggah Gambar Slider 1', 'wiz77' ),
        'section' => 'slider_section', // Bagian tempat kontrol ditampilkan
        'settings' => 'slider_image_1',
        'priority' => 10,
    )));
	
	// Tambahkan pengaturan kustom untuk upload gambar slider
    $wp_customize->add_setting( 'slider_image_2', array(
        'default' => '',
        'transport' => 'refresh', // Metode penyimpanan data
    ));

    // Tambahkan kontrol untuk upload gambar slider
    $wp_customize->add_control( new WP_Customize_Upload_Control( $wp_customize, 'slider_image_2_control', array(
        'label' => __( 'Unggah Gambar Slider 2', 'wiz77' ),
        'section' => 'slider_section', // Bagian tempat kontrol ditampilkan
        'settings' => 'slider_image_2',
        'priority' => 10,
    )));
	
	// Buat sebuah section untuk colors settings di dalam panel "Phishingpolice Settings"
    $wp_customize->add_section( 'color_section', array(
        'title' => __( 'Colors Settings', 'phishingpolice' ),
        'panel' => 'custom_panel',
        'priority' => 10,
    ));
	
	// Buat sebuah section untuk link settings di dalam panel "Wiz77 Settings"
    $wp_customize->add_section( 'links_section', array(
        'title' => __( 'Link Game Menu', 'phishingpolice' ),
        'panel' => 'custom_panel',
        'priority' => 9,
    ));

    // Tambahkan pengaturan kustom untuk input teks link di dalam section "Link Settings"
    $wp_customize->add_setting( 'custom_link_game_menu', array(
        'default' => '',
        'transport' => 'refresh', // Metode penyimpanan data
    ));

    // Tambahkan kontrol untuk input teks link di dalam section "Link Settings"
    $wp_customize->add_control( 'custom_link_game_menu_control', array(
        'label' => __( 'Game Menu Link', 'wiz77' ),
        'section' => 'links_section', // Bagian tempat kontrol ditampilkan
        'settings' => 'custom_link_game_menu',
        'type' => 'text', // Tipe kontrol
        'priority' => 10,
    ));
	
	// Tambahkan pengaturan kustom untuk warna latar belakang di dalam section "Colors Settings"
    $wp_customize->add_setting( 'custom_color_background', array(
        'default' => '#1e0000',
        'transport' => 'refresh', // Metode penyimpanan data
    ));

    // Tambahkan kontrol untuk pengaturan kustom warna latar belakang di dalam section "Colors Settings"
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'custom_background_control', array(
        'label' => __( 'Warna Background', 'phishingpolice' ),
        'section' => 'color_section', // Bagian tempat kontrol ditampilkan
        'settings' => 'custom_color_background',
        'priority' => 10,
    )));

    // Tambahkan pengaturan kustom untuk warna header
    $wp_customize->add_setting( 'custom_color_header', array(
        'default' => '#000000',
        'transport' => 'refresh', // Metode penyimpanan data
    ));

    // Tambahkan kontrol untuk pengaturan kustom warna header
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'custom_color_header_control', array(
        'label' => __( 'Warna Header', 'phishingpolice' ),
        'section' => 'color_section', // Bagian tempat kontrol ditampilkan
        'settings' => 'custom_color_header',
        'priority' => 11, // Prioritas agar kontrol ini muncul setelah kontrol sebelumnya
        'panel' => 'custom_panel', // Panel yang baru saja dibuat
    )));
	
	// 
    $wp_customize->add_setting( 'custom_menu_game', array(
        'default' => '#d51307',
        'transport' => 'refresh', // Metode penyimpanan data
    ));

    // 
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'custom_menu_game_control', array(
        'label' => __( 'Warna Menu Game Button', 'phishingpolice' ),
        'section' => 'color_section', // Bagian tempat kontrol ditampilkan
        'settings' => 'custom_menu_game',
        'priority' => 11, // Prioritas agar kontrol ini muncul setelah kontrol sebelumnya
        'panel' => 'custom_panel', // Panel yang baru saja dibuat
    )));
	
	// 
    $wp_customize->add_setting( 'custom_color_login', array(
        'default' => '#d51307',
        'transport' => 'refresh', // Metode penyimpanan data
    ));

    // 
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'custom_color_login_control', array(
        'label' => __( 'Warna Tombol LOGIN dan Menu Mobile', 'phishingpolice' ),
        'section' => 'color_section', // Bagian tempat kontrol ditampilkan
        'settings' => 'custom_color_login',
        'priority' => 11, // Prioritas agar kontrol ini muncul setelah kontrol sebelumnya
        'panel' => 'custom_panel', // Panel yang baru saja dibuat
    )));
	
	// 
    $wp_customize->add_setting( 'custom_color_daftar', array(
        'default' => '#f6bb23',
        'transport' => 'refresh', // Metode penyimpanan data
    ));

    // 
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'custom_color_daftar_control', array(
        'label' => __( 'Warna Tombol DAFTAR', 'phishingpolice' ),
        'section' => 'color_section', // Bagian tempat kontrol ditampilkan
        'settings' => 'custom_color_daftar',
        'priority' => 11, // Prioritas agar kontrol ini muncul setelah kontrol sebelumnya
        'panel' => 'custom_panel', // Panel yang baru saja dibuat
    )));
	
	// 
    $wp_customize->add_setting( 'custom_color_footer', array(
        'default' => '#4b120f',
        'transport' => 'refresh', // Metode penyimpanan data
    ));

    // 
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'custom_color_footer_control', array(
        'label' => __( 'Warna Footer Mobile', 'phishingpolice' ),
        'section' => 'color_section', // Bagian tempat kontrol ditampilkan
        'settings' => 'custom_color_footer',
        'priority' => 11, // Prioritas agar kontrol ini muncul setelah kontrol sebelumnya
        'panel' => 'custom_panel', // Panel yang baru saja dibuat
    )));
	
	// 
    $wp_customize->add_setting( 'custom_color_border', array(
        'default' => '#d51307',
        'transport' => 'refresh', // Metode penyimpanan data
    ));

    // 
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'custom_color_border_control', array(
        'label' => __( 'Warna Border', 'phishingpolice' ),
        'section' => 'color_section', // Bagian tempat kontrol ditampilkan
        'settings' => 'custom_color_border',
        'priority' => 11, // Prioritas agar kontrol ini muncul setelah kontrol sebelumnya
        'panel' => 'custom_panel', // Panel yang baru saja dibuat
    )));
	
	// 
    $wp_customize->add_setting( 'custom_color_link', array(
        'default' => '#d51307',
        'transport' => 'refresh', // Metode penyimpanan data
    ));

    // 
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'custom_color_link_control', array(
        'label' => __( 'Warna Link', 'phishingpolice' ),
        'section' => 'color_section', // Bagian tempat kontrol ditampilkan
        'settings' => 'custom_color_link',
        'priority' => 11, // Prioritas agar kontrol ini muncul setelah kontrol sebelumnya
        'panel' => 'custom_panel', // Panel yang baru saja dibuat
    )));
}

add_action( 'customize_register', 'custom_theme_customize_panel' );