// sample_6_storage.js
function kjasdn7u3i1_setLocalStorage(key, value) {
  try {
    localStorage.setItem(key, JSON.stringify(value));
    return true;
  } catch (error) {
    console.error('Error saving to localStorage:', error);
    return false;
  }
}

function kjasdn6o8p4_getLocalStorage(key, defaultValue = null) {
  try {
    const item = localStorage.getItem(key);
    return item ? JSON.parse(item) : defaultValue;
  } catch (error) {
    console.error('Error reading from localStorage:', error);
    return defaultValue;
  }
}

function kjasdn5a2s9_clearExpiredStorage(prefix, maxAge) {
  const now = Date.now();
  Object.keys(localStorage).forEach(key => {
    if (key.startsWith(prefix)) {
      const data = kjasdn6o8p4_getLocalStorage(key);
      if (data && data.timestamp && now - data.timestamp > maxAge) {
        localStorage.removeItem(key);
      }
    }
  });
}