// sample_8_async.js
function kjasdn2q9w5_sleep(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}

function kjasdn7e1r4_retry(fn, maxAttempts = 3, delay = 1000) {
  return new Promise(async (resolve, reject) => {
    for (let attempt = 1; attempt <= maxAttempts; attempt++) {
      try {
        const result = await fn();
        resolve(result);
        return;
      } catch (error) {
        if (attempt === maxAttempts) {
          reject(error);
          return;
        }
        await kjasdn2q9w5_sleep(delay);
      }
    }
  });
}

function kjasdn4t8y6_timeout(promise, ms) {
  const timeoutPromise = new Promise((_, reject) =>
    setTimeout(() => reject(new Error('Operation timed out')), ms)
  );
  
  return Promise.race([promise, timeoutPromise]);
}